//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Simple_DIO.h"
#include "drvlinx.h"   /* DriverLINX API */
#include "dlcodes.h"   /* DriverLINX error codes and macros */
// be sure to add c:\drvlinx4\dlapi\drvlnxbc.lib to the project

// DriverLINX variables and function prototypes
DL_SERVICEREQUEST SR;    // declare the Service Request Structure
HANDLE hInstance;       // instance handle for the driver
HANDLE hWin;           // handle to this application
// variables used for error handling
char errString[100];
DWORD size=50;
int errNumber;

unsigned long DLMsg; // an unsigned variable to hold the
                     // the value assigned by RegisterWindowMessage()
                     
// a handle to this application will be necessary for processing
// of any windows messages sent by DriverLINX.  For POLLED mode
// tasks, this is not so useful, but for INTERRUPT OR DMA tasks, the
// BufferFilled or ServiceDone messages are very helpful for control of
// program flow

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::cmdOpenClick(TObject *Sender)
{

       // get the handle of this application's window
      hWin = Form1->Handle;

	// call OpenDriverLINX()
	hInstance = (HANDLE)OpenDriverLINX( hWin, "kpcipio" );
        // if not using the KPCI=PIO24 board, replace the driver
        // name kpcipio with the name of your driver, e.g., kpci3160,
        // kpci3100, kpci3108, kmbpio, etc.
        
        Form1->SetFocus();  // set focus back to our application

        // now enable Init button
        cmdInit->Enabled = True;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::cmdReadDIClick(TObject *Sender)
{       // clear lblMessage
        lblMessage->Caption = "";
	SR.hWnd = hWin;
	SR.device = 0;
	SR.subsystem = DI; // use the Digital Input subsystem of the board
	SR.mode = POLLED;
	SR.operation = START;
 	SR.channels.nChannels = 1;  // a single channel
	SR.channels.chanGain[ 0 ].channel = 0;  // it is channel 0
        // should DriverLIXN send any messages.......
        if (chkMsg->State == cbUnchecked)
        {
        SR.taskFlags = NO_SERVICESTART | NO_SERVICEDONE;
        }
        else
        {
        SR.taskFlags = DL_SERVICEDONE;  // please send ServiceDone message
        }

	// call DriverLINX()
	if( DriverLINX( &SR ) != NoErr )
        {
          errNumber = getErrCode(SR.result);
        // errNumber corresponds to DriverLINX documentation
        ReturnMessageString(SR.hWnd,SR.result,errString,size);
        // errString corresponds to DriverLINX documentation
        lblMessage->Caption = errString;

	}
        else
        {
         lblDI->Caption = SR.status.u.ioValue;
         // status.u.ioValue member of SR structure can
         // hold a single value, no need to allocate a buffer
         // to hold the value.
        }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::cmdInitClick(TObject *Sender)
{
     	memset( &SR, 0, sizeof( DL_SERVICEREQUEST ) );
	DL_SetServiceRequestSize( SR );

	SR.hWnd = hWin;
        SR.operation = INITIALIZE;  // carry out an initialization operation
	SR.device = 0;  // the device number assigned in DLinx Config Panel
	SR.subsystem = DEVICE;
	SR.mode = OTHER;
    	// call DriverLINX() to execute the task specified by the
        // members of the SR structure
	if( DriverLINX( &SR ) != NoErr )
         {// respond to error
         cmdReadDI->Enabled = False;
         errNumber = getErrCode(SR.result);
        // errNumber corresponds to DriverLINX documentation
        ReturnMessageString(SR.hWnd,SR.result,errString,size);
        // errString corresponds to DriverLINX documentation
        lblMessage->Caption = errString;
          }
        else
        {
        // all is well, allow reading the DI channel
        cmdReadDI->Enabled = True;
        
         }

}

//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
   // get a unique identifier from Windows for DriverLINX messages
   DLMsg = RegisterWindowMessage(DL_MESSAGE);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::WndProc(Messages::TMessage &Message)
{
  if ( Message.Msg == DLMsg) // first test to see if this is from DriverLINX
    {
       switch(Message.WParam)  // if so, which DriverLINX message?
       {
        case DL_SERVICEDONE:
        lblMessage->Caption = "Service Done Message Posted";
        Beep();
        break;
        case DL_BUFFERFILLED:
        lblMessage->Caption = "Buffer Filled Message Posted";
        break;
        }  // switch
    } // if

  // maybe the message was not for DriverLINX at all......
  TForm::WndProc( Message );  // call Default message handler for TForm class.
}
void __fastcall TForm1::CleanUpDriverLINX(TObject *Sender)
{
	CloseDriverLINX(hInstance); //close the DriverLINX driver
	hInstance=NULL; //for safety, make sure hInstance isn't pointing to anything
	delete(&SR); //de-allocate the memory used by the service request        
}
//---------------------------------------------------------------------------

